<?php namespace Visiosoft\CrmModule\Http\Controller\Admin;

use Illuminate\Support\Facades\Auth;
use Visiosoft\CrmModule\Note\Contract\NoteRepositoryInterface;
use Visiosoft\CrmModule\Note\Form\NoteFormBuilder;
use Visiosoft\CrmModule\Note\Table\NoteTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\GlobalHelperExtension\Traits\RedirectBackTrait;

class NotesController extends AdminController
{

    use RedirectBackTrait;

    /**
     * Display an index of existing entries.
     *
     * @param NoteTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(NoteTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param NoteFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(NoteFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param NoteFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(NoteFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    /**
     * @param $id
     * @return mixed
     */
    public function quickCreate($id = null)
    {
        $request = request();
        $noteRepository = app(NoteRepositoryInterface::class);

        $noteParams = [
            'content' => $request['content'],
            'customer_id' => $request['customer_id'],
            'deal_id' => $request['deal_id'] ?? '',
            'salesman_id' => Auth::id()
        ];

        $note = $noteRepository->create($noteParams);
        if (!$note) {
            return $this->redirectBackWithError(trans('visiosoft.module.crm::message.an_error_occured'));
        }

        return $this->redirectBackWithSuccess(trans('visiosoft.module.crm::message.note_created'));
    }

}
