<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Anomaly\UsersModule\User\UserModel;

class VisiosoftModuleCrmCreateActivitiesStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'activities',
        'title_column' => 'activity',
        'translatable' => true,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'activity' => 'anomaly.field_type.textarea',
        'type' => 'anomaly.field_type.text',
        'related_id' => "anomaly.field_type.integer", // related model record id
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class
            ]
        ]
    ];


    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'activity',
        'type',
        'related_id',
        'user'
    ];

}
