<?php namespace Visiosoft\CrmModule\Http\Controller\Admin;

use Illuminate\Support\Facades\Auth;
use Visiosoft\CrmModule\Activity\Contract\ActivityRepositoryInterface;
use Visiosoft\CrmModule\Customer\Contract\CustomerRepositoryInterface;
use Visiosoft\CrmModule\Customer\Form\CustomerFormBuilder;
use Visiosoft\CrmModule\Customer\Table\CustomerTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\GlobalHelperExtension\Traits\RedirectBackTrait;
use Yajra\DataTables\DataTables;

class CustomersController extends AdminController
{
    use RedirectBackTrait;

    private $customerRepository;
    private $activityRepository;

    public function __construct()
    {
        $this->customerRepository = app(CustomerRepositoryInterface::class);
        $this->activityRepository = app(ActivityRepositoryInterface::class);
        parent::__construct();
    }

    /**
     * Display an index of existing entries.
     *
     * @param CustomerTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CustomerTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param CustomerFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(CustomerFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param CustomerFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(CustomerFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function quickCreate($id = null)
    {
        $request = request();
        $customerRepository = app(CustomerRepositoryInterface::class);

        $customerParams = [
            'name' => $request['customer_name'] ?? '',
            'email' => $request['email'] ?? '',
            'phone' => $request['phone'] ?? '',
            'lat' => $request['lat'] ?? '',
            'lng' => $request['lat'] ?? '',
            'address' => $request['address'] ?? '',
            'additional_info' => $request['additional_info'] ?? ''
        ];

        if ($id) {
            try {
                $customer = $customerRepository->find($id);
                $customer->update($customerParams);
                return $this->redirectBackWithSuccess(trans('visiosoft.module.crm::message.customer_updated'));
            } catch (\Exception $e) {
                return $this->redirectBackWithError(trans('visiosoft.module.crm::message.an_error_occured'), false);
            }
        }

        $customer = $customerRepository->create($customerParams);
        if (!$customer) {
            return $this->redirectBackWithError(trans('visiosoft.module.crm::message.an_error_occured'));
        }

        return $this->redirectBackWithSuccess(trans('visiosoft.module.crm::message.customer_created'));
    }


    public function getCustomersDatatable()
    {
        $customers = $this->customerRepository->getCustomers();
        return DataTables::of($customers)->toJson();
    }
}
