<?php namespace Visiosoft\CrmModule\Appointment;

use Visiosoft\CrmModule\Appointment\Contract\AppointmentRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class AppointmentRepository extends EntryRepository implements AppointmentRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var AppointmentModel
     */
    protected $model;

    /**
     * Create a new AppointmentRepository instance.
     *
     * @param AppointmentModel $model
     */
    public function __construct(AppointmentModel $model)
    {
        $this->model = $model;
    }

    public function getAppointments()
    {
        return $this->model->newQuery()->get();
    }
}
