<?php

namespace Visiosoft\CrmModule\Models;

use Illuminate\Support\Facades\Auth;

class Activity
{
    private ActivityString $activityTranslate;

    private $oldData;
    private $newData;

    private int $relatedID;

    private int $recordID;

    public function __construct(ActivityString $activityTranslate, int $recordID, int $relatedID)
    {
        $this->activityTranslate = $activityTranslate;
        $this->relatedID = $relatedID;
        $this->recordID = $recordID;
    }

    /**
     * @return string
     */
    public function getActivity(): string
    {
        $activity = [
            'user_display' => Auth::user()->name(),
            'record_id' => $this->recordID,
            'translate' => $this->activityTranslate->getTranslateObject(),
        ];

        if (!empty($this->oldData) && !empty($this->newData)) {
            $activity['data_changes'] = $this->compare();
        }

        return json_encode($activity);
    }

    /**
     * @return int
     */
    public function getRelatedID(): int
    {
        return $this->relatedID;
    }

    /**
     * @return int
     */
    public function getUserID(): int
    {
        return Auth::id();
    }

    /**
     * @return int
     */
    public function getUser(): int
    {
        return Auth::user();
    }

    public function setOldData($oldData)
    {
        $this->oldData = $oldData;
    }

    public function setNewData($newData, $selects = null)
    {
        $data = [];
        if ($selects) {
            foreach ($selects as $select) {
                if (isset($newData[$select])) {
                    $data[$select] = $newData[$select];
                }
            }
        } else {
            $data = $newData;
        }

        $this->newData = $data;
    }

    private function compare(): string
    {
        if (is_object($this->oldData)) {
            $this->setOldData(method_exists($this->oldData, 'toArray') ? $this->oldData->toArray() : (array)$this->oldData);
        }

        if (is_object($this->newData)) {
            $this->setNewData(method_exists($this->newData, 'toArray') ? $this->newData->toArray() : (array)$this->newData);
        }

        $differences = [];
        $ignores = [
            'updated_at',
            'created_at',
            'updated_by_id',
            'created_by_id',

        ];

        foreach ($this->oldData as $key => $value) {
            if (!in_array($key, $ignores) && array_key_exists($key, $this->newData) && $value != $this->newData[$key]) {
                $differences[] = "" . trans('visiosoft.module.crm::field.' . $key . '.name') . ": {$value} => {$this->newData[$key]} <br>";
            }
        }

        return implode("\n", $differences);
    }


}