<?php namespace Visiosoft\CrmModule\Http\Controller\Admin;

use Illuminate\Contracts\Foundation\Application;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Auth;
use Visiosoft\ConnectModule\Traits\ApiReturnResponseTrait;
use Visiosoft\CrmModule\Activity\Contract\ActivityRepositoryInterface;
use Visiosoft\CrmModule\Deal\Contract\DealRepositoryInterface;
use Visiosoft\CrmModule\Deal\Form\DealFormBuilder;
use Visiosoft\CrmModule\Deal\Table\DealTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\CrmModule\Models\ActivityString;
use Visiosoft\GlobalHelperExtension\Traits\RedirectBackTrait;

class DealsController extends AdminController
{
    use RedirectBackTrait;
    use ApiReturnResponseTrait;

    private $activityRepository;

    public function __construct()
    {
        $this->activityRepository = app(ActivityRepositoryInterface::class);
        parent::__construct();
    }

    /**
     * Display an index of existing entries.
     *
     * @param DealTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(DealTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param DealFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(DealFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param DealFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(DealFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    /**
     * @return RedirectResponse
     */
    public function quickCreate(): \Illuminate\Http\RedirectResponse
    {
        $request = request()->post();
        $dealRepository = app(DealRepositoryInterface::class);
        $dealParams = [
            'name' => $request['name'],
            'deal_type_id' => $request['deal_type_id'],
            'deal_stage_id' => $request['deal_stage_id'],
            'priority_id' => $request['priority_id'],
            'customer_id' => $request['customer_id'],
            'amount' => $request['amount'],
            'salesman_id' => Auth::id()
        ];


        if (!empty($request['deal_id'])) {
            $deal = $dealRepository->find($request['deal_id']);
            if ($deal) {
                if ($deal->update($dealParams)) {
                    return $this->redirectBackWithSuccess(trans('visiosoft.module.crm::message.deal_updated'));
                } else {
                    return $this->redirectBackWithError(trans('visiosoft.module.crm::message.an_error_occured'));
                }
            }
        }

        $deal = $dealRepository->create($dealParams);
        if (!$deal) {
            return $this->redirectBackWithError(trans('visiosoft.module.crm::message.an_error_occured'));
        }

        return $this->redirectBackWithSuccess(trans('visiosoft.module.crm::message.deal_created'));
    }

}
