<?php namespace Visiosoft\CrmModule\Http\Controller\Admin;

use Illuminate\Support\Facades\Auth;
use Visiosoft\CrmModule\Appointment\Contract\AppointmentRepositoryInterface;
use Visiosoft\CrmModule\Appointment\Form\AppointmentFormBuilder;
use Visiosoft\CrmModule\Appointment\Table\AppointmentTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\GlobalHelperExtension\Traits\RedirectBackTrait;

class AppointmentsController extends AdminController
{

    use RedirectBackTrait;

    /**
     * Display an index of existing entries.
     *
     * @param AppointmentTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(AppointmentTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param AppointmentFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(AppointmentFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param AppointmentFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(AppointmentFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function quickCreate($id = null)
    {
        $request = request()->post();
        $appointmentRepository = app(AppointmentRepositoryInterface::class);

        $appointmentParams = [
            'appointment_date' => $request['appointment_date'],
            'note' => $request['note'],
            'name' => $request['name'] ?? '',
            'customer_id' => $request['customer_id'],
            'deal_id' => $request['deal_id'] ?? '',
            'salesman_id' => Auth::id(),
        ];

        $appointment = $appointmentRepository->create($appointmentParams);
        if (!$appointment) {
            return $this->redirectBackWithError(trans('visiosoft.module.crm::message.an_error_occured'));
        }

        return $this->redirectBackWithSuccess(trans('visiosoft.module.crm::message.note_created'));
    }
}
