<?php

namespace Visiosoft\CrmModule\Models;

class ActivityString
{
    private string $activityTranslatePath;
    private array $activityTranslateKeys;
    private array $activityTranslateParams;

    public function __construct(string $activityTranslatePath, array $activityTranslateKeys = null, array $activityTranslateParams = null)
    {
        $this->activityTranslatePath = $activityTranslatePath;
        $this->activityTranslateKeys = $activityTranslateKeys;
        $this->activityTranslateParams = $activityTranslateParams;
    }

    public function getTranslateObject()
    {
        return [
            'path' => $this->activityTranslatePath,
            'keys' => $this->activityTranslateKeys,
            'params' => $this->activityTranslateParams,
        ];
    }


    public function getTranslatedString()
    {
        return trans($this->activityTranslatePath, array_combine($this->activityTranslateKeys, $this->activityTranslateParams));
    }

}