<?php

namespace Visiosoft\CrmModule\Listeners;

use Visiosoft\ApiGooglecontactsExtension\Event\ContactsReceivedEvent;
use Visiosoft\CrmModule\Customer\Contract\CustomerRepositoryInterface;

class GoogleContactsReceived
{
    public function handle(ContactsReceivedEvent $contactsReceivedEvent, CustomerRepositoryInterface $customerRepository)
    {

        foreach ($contactsReceivedEvent->getContacts() as $contact) {
            $customer = $customerRepository->findBy('phone', $contact);
            if (!$customer) {
                $customerParams = [
                    'name' => $contact->getName(),
                    'email' => $contact->getEmail(),
                    'phone' => $contact->getPhone()
                ];
                $customerRepository->create($customerParams);
            }
        }

    }
}