<?php namespace Visiosoft\CrmModule\Customer;

use Visiosoft\CrmModule\Customer\Contract\CustomerRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use function Clue\StreamFilter\fun;

class CustomerRepository extends EntryRepository implements CustomerRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var CustomerModel
     */
    protected $model;

    /**
     * Create a new CustomerRepository instance.
     *
     * @param CustomerModel $model
     */
    public function __construct(CustomerModel $model)
    {
        $this->model = $model;
    }


    public function getCustomers()
    {
        return $this->model->newQuery()->get();
    }

    public function getCustomer($id)
    {
        $salesManFields = [
            'id', 'first_name', 'last_name', 'phone', 'email'
        ];

        return $this->newQuery()
            ->where('id', $id)
            ->with([
                'notes.salesman' => function ($query) use ($salesManFields) {
                    $query->select($salesManFields);
                },
                'appointments.salesman' => function ($query) use ($salesManFields) {
                    $query->select($salesManFields);
                },
                'deals.salesman' => function ($query) use ($salesManFields) {
                    $query->select($salesManFields);
                },
                'deals.items.item',
                'deals.priority',
                'deals.notes',
                'deals.dealStage',
                'deals.dealType',
                'activities'
            ])->first();
    }
}
