<?php namespace Visiosoft\CrmModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\ApiGooglecontactsExtension\Event\ContactsReceivedEvent;
use Visiosoft\CrmModule\Deal\DealObserver;
use Visiosoft\CrmModule\DealItem\Contract\DealItemRepositoryInterface;
use Visiosoft\CrmModule\DealItem\DealItemRepository;
use Anomaly\Streams\Platform\Model\Crm\CrmDealItemsEntryModel;
use Visiosoft\CrmModule\DealItem\DealItemModel;
use Visiosoft\CrmModule\Item\Contract\ItemRepositoryInterface;
use Visiosoft\CrmModule\Item\ItemRepository;
use Anomaly\Streams\Platform\Model\Crm\CrmItemsEntryModel;
use Visiosoft\CrmModule\Item\ItemModel;
use Visiosoft\CrmModule\Listeners\GoogleContactsReceived;
use Visiosoft\CrmModule\Priority\Contract\PriorityRepositoryInterface;
use Visiosoft\CrmModule\Priority\PriorityRepository;
use Anomaly\Streams\Platform\Model\Crm\CrmPriorityEntryModel;
use Visiosoft\CrmModule\Priority\PriorityModel;
use Visiosoft\CrmModule\Activity\Contract\ActivityRepositoryInterface;
use Visiosoft\CrmModule\Activity\ActivityRepository;
use Anomaly\Streams\Platform\Model\Crm\CrmActivitiesEntryModel;
use Visiosoft\CrmModule\Activity\ActivityModel;
use Visiosoft\CrmModule\Appointment\Contract\AppointmentRepositoryInterface;
use Visiosoft\CrmModule\Appointment\AppointmentRepository;
use Anomaly\Streams\Platform\Model\Crm\CrmAppointmentsEntryModel;
use Visiosoft\CrmModule\Appointment\AppointmentModel;
use Visiosoft\CrmModule\Note\Contract\NoteRepositoryInterface;
use Visiosoft\CrmModule\Note\NoteRepository;
use Anomaly\Streams\Platform\Model\Crm\CrmNotesEntryModel;
use Visiosoft\CrmModule\Note\NoteModel;
use Visiosoft\CrmModule\DealStage\Contract\DealStageRepositoryInterface;
use Visiosoft\CrmModule\DealStage\DealStageRepository;
use Anomaly\Streams\Platform\Model\Crm\CrmDealStagesEntryModel;
use Visiosoft\CrmModule\DealStage\DealStageModel;
use Visiosoft\CrmModule\DealType\Contract\DealTypeRepositoryInterface;
use Visiosoft\CrmModule\DealType\DealTypeRepository;
use Anomaly\Streams\Platform\Model\Crm\CrmDealTypesEntryModel;
use Visiosoft\CrmModule\DealType\DealTypeModel;
use Visiosoft\CrmModule\Customer\Contract\CustomerRepositoryInterface;
use Visiosoft\CrmModule\Customer\CustomerRepository;
use Anomaly\Streams\Platform\Model\Crm\CrmCustomersEntryModel;
use Visiosoft\CrmModule\Customer\CustomerModel;
use Visiosoft\CrmModule\Deal\Contract\DealRepositoryInterface;
use Visiosoft\CrmModule\Deal\DealRepository;
use Anomaly\Streams\Platform\Model\Crm\CrmDealsEntryModel;
use Visiosoft\CrmModule\Deal\DealModel;

class CrmModuleServiceProvider extends AddonServiceProvider
{
    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/crm/deal_items' => 'Visiosoft\CrmModule\Http\Controller\Admin\DealItemsController@index',
        'admin/crm/deal_items/create' => 'Visiosoft\CrmModule\Http\Controller\Admin\DealItemsController@create',
        'admin/crm/deal_items/edit/{id}' => 'Visiosoft\CrmModule\Http\Controller\Admin\DealItemsController@edit',
        'admin/crm/items' => 'Visiosoft\CrmModule\Http\Controller\Admin\ItemsController@index',
        'admin/crm/items/create' => 'Visiosoft\CrmModule\Http\Controller\Admin\ItemsController@create',
        'admin/crm/items/edit/{id}' => 'Visiosoft\CrmModule\Http\Controller\Admin\ItemsController@edit',
        'admin/crm/priority' => 'Visiosoft\CrmModule\Http\Controller\Admin\PriorityController@index',
        'admin/crm/priority/create' => 'Visiosoft\CrmModule\Http\Controller\Admin\PriorityController@create',
        'admin/crm/priority/edit/{id}' => 'Visiosoft\CrmModule\Http\Controller\Admin\PriorityController@edit',
        'admin/crm/activities' => 'Visiosoft\CrmModule\Http\Controller\Admin\ActivitiesController@index',
        'admin/crm/activities/create' => 'Visiosoft\CrmModule\Http\Controller\Admin\ActivitiesController@create',
        'admin/crm/activities/edit/{id}' => 'Visiosoft\CrmModule\Http\Controller\Admin\ActivitiesController@edit',
        'admin/crm/appointments' => 'Visiosoft\CrmModule\Http\Controller\Admin\AppointmentsController@index',
        'admin/crm/appointments/create' => 'Visiosoft\CrmModule\Http\Controller\Admin\AppointmentsController@create',
        'admin/crm/appointments/edit/{id}' => 'Visiosoft\CrmModule\Http\Controller\Admin\AppointmentsController@edit',
        'admin/crm/notes' => 'Visiosoft\CrmModule\Http\Controller\Admin\NotesController@index',
        'admin/crm/notes/create' => 'Visiosoft\CrmModule\Http\Controller\Admin\NotesController@create',
        'admin/crm/notes/edit/{id}' => 'Visiosoft\CrmModule\Http\Controller\Admin\NotesController@edit',
        'admin/crm/deal_stages' => 'Visiosoft\CrmModule\Http\Controller\Admin\DealStagesController@index',
        'admin/crm/deal_stages/create' => 'Visiosoft\CrmModule\Http\Controller\Admin\DealStagesController@create',
        'admin/crm/deal_stages/edit/{id}' => 'Visiosoft\CrmModule\Http\Controller\Admin\DealStagesController@edit',
        'admin/crm/deal_types' => 'Visiosoft\CrmModule\Http\Controller\Admin\DealTypesController@index',
        'admin/crm/deal_types/create' => 'Visiosoft\CrmModule\Http\Controller\Admin\DealTypesController@create',
        'admin/crm/deal_types/edit/{id}' => 'Visiosoft\CrmModule\Http\Controller\Admin\DealTypesController@edit',
        'admin/crm/customers' => 'Visiosoft\CrmModule\Http\Controller\Admin\CustomersController@index',
        'admin/crm/customers/create' => 'Visiosoft\CrmModule\Http\Controller\Admin\CustomersController@create',
        'admin/crm/customers/edit/{id}' => 'Visiosoft\CrmModule\Http\Controller\Admin\CustomersController@edit',
        'admin/crm' => 'Visiosoft\CrmModule\Http\Controller\Admin\DealsController@index',
        'admin/crm/create' => 'Visiosoft\CrmModule\Http\Controller\Admin\DealsController@create',
        'admin/crm/edit/{id}' => 'Visiosoft\CrmModule\Http\Controller\Admin\DealsController@edit',
        '/admin/crm/get/customers/datatable' => [
            'as' => 'visiosoft.module.crm::get.customers.datatable',
            'uses' => 'Visiosoft\CrmModule\Http\Controller\Admin\CustomersController@getCustomersDatatable',
        ],
        '/admin/crm/customer/quick_create/{id?}' => [
            'as' => 'visiosoft.module.crm::customer.quick_create',
            'uses' => 'Visiosoft\CrmModule\Http\Controller\Admin\CustomersController@quickCreate',
        ],
        '/admin/crm/note/quick_create' => [
            'as' => 'visiosoft.module.crm::notes.quick_create',
            'uses' => 'Visiosoft\CrmModule\Http\Controller\Admin\NotesController@quickCreate',
        ],
        '/admin/crm/appointments/quick_create' => [
            'as' => 'visiosoft.module.crm::appointments.quick_create',
            'uses' => 'Visiosoft\CrmModule\Http\Controller\Admin\AppointmentsController@quickCreate',
        ],
        '/admin/crm/deals/quick_create' => [
            'as' => 'visiosoft.module.crm::deals.quick_create',
            'uses' => 'Visiosoft\CrmModule\Http\Controller\Admin\DealsController@quickCreate',
        ],
        '/admin/crm/deals/quick_update/{id?}' => [
            'as' => 'visiosoft.module.crm::deals.quick_update',
            'uses' => 'Visiosoft\CrmModule\Http\Controller\Admin\DealsController@quickUpdate',
        ],
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        CrmDealItemsEntryModel::class => DealItemModel::class,
        CrmItemsEntryModel::class => ItemModel::class,
        CrmPriorityEntryModel::class => PriorityModel::class,
        CrmActivitiesEntryModel::class => ActivityModel::class,
        CrmAppointmentsEntryModel::class => AppointmentModel::class,
        CrmNotesEntryModel::class => NoteModel::class,
        CrmDealStagesEntryModel::class => DealStageModel::class,
        CrmDealTypesEntryModel::class => DealTypeModel::class,
        CrmCustomersEntryModel::class => CustomerModel::class,
        CrmDealsEntryModel::class => DealModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        DealItemRepositoryInterface::class => DealItemRepository::class,
        ItemRepositoryInterface::class => ItemRepository::class,
        PriorityRepositoryInterface::class => PriorityRepository::class,
        ActivityRepositoryInterface::class => ActivityRepository::class,
        AppointmentRepositoryInterface::class => AppointmentRepository::class,
        NoteRepositoryInterface::class => NoteRepository::class,
        DealStageRepositoryInterface::class => DealStageRepository::class,
        DealTypeRepositoryInterface::class => DealTypeRepository::class,
        CustomerRepositoryInterface::class => CustomerRepository::class,
        DealRepositoryInterface::class => DealRepository::class,
    ];

    protected $listeners = [
        ContactsReceivedEvent::class => [
            GoogleContactsReceived::class
        ]
    ];

}
