<?php namespace Visiosoft\CrmModule\Appointment;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Entry\EntryObserver;
use Carbon\Carbon;
use Visiosoft\CrmModule\Activity\Contract\ActivityRepositoryInterface;
use Visiosoft\CrmModule\Models\Activity;
use Visiosoft\CrmModule\Models\ActivityString;
use Visiosoft\CrmModule\Models\ActivityTypes;

class AppointmentObserver extends EntryObserver
{
    private $activityRepository;

    public function __construct()
    {
        $this->activityRepository = app(ActivityRepositoryInterface::class);
        parent::__construct();
    }

    public function created(EntryInterface $entry)
    {
        $activityTranslate = new ActivityString('visiosoft.module.crm::activity.appointment_created', ['date', 'note'],
            [Carbon::parse($entry->appointment_date)->format("Y-m-d H:i:s"),
                $entry->note
            ]);
        $this->activityRepository->createActivity(new Activity($activityTranslate, $entry->id, $entry->customer_id), new ActivityTypes('CUSTOMER'));
    }
}