<?php namespace Visiosoft\CrmModule\Activity;

use Visiosoft\CrmModule\Activity\Contract\ActivityInterface;
use Anomaly\Streams\Platform\Model\Crm\CrmActivitiesEntryModel;
use Visiosoft\CrmModule\Models\ActivityString;

class ActivityModel extends CrmActivitiesEntryModel implements ActivityInterface
{
    public function getActivityAttribute($value)
    {
        $decodedValue = json_decode($value);
        $translatedString = new ActivityString($decodedValue->translate->path, $decodedValue->translate->keys, $decodedValue->translate->params);
        $translatedString = $translatedString->getTranslatedString();
        $stringifiedValue = $decodedValue->user_display . " " . $translatedString;
        if (isset($decodedValue->data_changes)) {
            $stringifiedValue .=  "<br>" . $decodedValue->data_changes;
        }
        return $stringifiedValue;

    }
}
