<?php namespace Visiosoft\CrmModule\Note;

use Visiosoft\CrmModule\Note\Contract\NoteRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class NoteRepository extends EntryRepository implements NoteRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var NoteModel
     */
    protected $model;

    /**
     * Create a new NoteRepository instance.
     *
     * @param NoteModel $model
     */
    public function __construct(NoteModel $model)
    {
        $this->model = $model;
    }

    public function getNotes($customerID = null, $dealID = null, $salesmanID = null)
    {
        $notes = $this->model->newQuery();
        if ($customerID) {
            $notes->where('customer_id', $customerID);
        }

        if ($dealID) {
            $notes->where('deal_id', $dealID);
        }

        if ($salesmanID) {
            $notes->where('salesman_id', $salesmanID);
        }

        return $notes->orderBy('id','DESC')->get();

    }
}
