<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleCrmCreateNotesStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'notes',
        'title_column' => 'content',
        'translatable' => true,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'content' => 'anomaly.field_type.textarea',
        'salesman' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => Anomaly\UsersModule\User\UserModel::class,
                'mode' => "lookup"
            ]
        ],
        'deal' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => Visiosoft\CrmModule\Deal\DealModel::class,
                'mode' => "lookup"
            ]
        ],
        'customer' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => Visiosoft\CrmModule\Customer\CustomerModel::class
            ]
        ]
    ];


    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'content',
        'salesman',
        'deal',
        'customer'
    ];

}
