<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Illuminate\Support\Facades\Schema;

class VisiosoftExtensionCraftgateCreateUserTokenTable extends Migration
{

    /**
     * The database schema.
     *
     * @var \Illuminate\Database\Schema\Builder
     */
    protected $schema;

    /**
     * Create a new migration instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->schema = Schema::connection($this->getConnection());
    }

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $this->schema->create(
            'craftgate_user_token',
            function (Illuminate\Database\Schema\Blueprint $table) {
                $table->increments('id');
                $table->integer('user_id');
                $table->string('user_token');
                $table->string('card_token');
                $table->boolean('is_default')->default(false);
                $table->softDeletes();
                $table->timestamps();
            }
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $this->schema->drop('craftgate_user_token');
    }
}
