<?php namespace Visiosoft\CraftgateExtension;

use Anomaly\Streams\Platform\Addon\Extension\Extension;
use Visiosoft\CraftgateExtension\Commands\CardProvider;

class CraftgateExtension extends Extension
{
    protected $provides = 'visiosoft.module.payment::save_and_pay_provider.craftgate';

    public function payBySavedCard(
        $providerUserID,
        $defaultCardID,
        $price,
        $currency = '',
        $items = [],
        $buyer = [],
        $invoice_id = '')
    {

        try {
            $response = $this->getProvider()->payBySavedCard($providerUserID, $defaultCardID, $price, $currency, $items, $buyer, $invoice_id);

            if (isset($response->data) && $response->data->paymentStatus == 'SUCCESS') {
                return [
                    'status' => 'success',
                    'payment_intent_id' => $response->data->id,
                ];
            }

            return [
                'status' => 'fail'
            ];
        } catch (\Exception $e) {

            $this->logError($e);
            return $e->getMessage();

        }
    }

    /*
     * Save card to database and also send to craftgate
     *
     * params: $cardHolderName, $cardNumber, $expireYear, $expireMonth, $cardAlias, $cardUserKey
     * return: object
     */
    public function createCard(
        $cardHolderName,
        $cardNumber,
        $expireYear,
        $expireMonth,
        $cvc = null,
        $email = null,
        $cardUserKey = null,
        $cardAlias = null)
    {

        try {

             $response = $this->getProvider()
                ->createCard(
                    $cardHolderName,
                    $cardNumber,
                    $expireYear,
                    $expireMonth,
                    $cvc,
                    $email,
                    $cardUserKey,
                    $cardAlias);

            if (isset($response->data) && $response->data) {

                 return $this->format(
                     $response->data->cardUserKey,
                     $response->data->cardAssociation,
                     $response->data->cardExpiryStatus,
                     $response->data->lastFourDigits,
                     $response->data->cardToken
                 );

            }


            return false;
        } catch (\Exception $e) {

            $this->logError($e);
            return $e->getMessage();

        }

    }

    /*
     * Delete card from database and also send delete request to craftgate
     *
     * params: $cardID
     * return: boolean
     */
    public function removeCard($cardToken)
    {
        try {

            return $this->getProvider()->removeCard($cardToken);

        }
        catch (\Exception $e) {

            $this->logError($e);

            return false;

        }
    }


    /*
     * Get Card Provider instance from CardProvider class
     *
     * params: $userId
     * return: object
     */
    public function getProvider()
    {
        try {

            return new CardProvider();

        } catch (\Exception $e) {

            $this->logError($e);

            return $e->getMessage();

        }
    }

    /*
     * Logging errors to storage folder
     *
     * params: $error
     * return: void
     */
    public function logError($error)
    {
        return $this->getProvider()->logError($error);
    }

    /*
     * Formatting card info according to the structure
     */
    public function format($cardUserKey, $cardAssociation, $cardExpiryStatus, $lastFourDigits, $cardToken)
    {

        // null fields are not returning from craftgate
        return [
            'service_payment_method_id' => $cardToken,
            'service' => 'craftgate',
            'customer' => $cardUserKey,
            'card' => [
                'brand' => $cardAssociation,
                'exp_month' => null,
                'exp_year' => null,
                'expired' => $cardExpiryStatus,
                'last4' => $lastFourDigits,
                'token' => $cardToken
            ]
        ];

    }

}
