<?php namespace Visiosoft\CraftgateExtension;

use Anomaly\Streams\Platform\Addon\Extension\Extension;
use Visiosoft\CraftgateExtension\Commands\CardProvider;

class CraftgateExtension extends Extension
{
    protected $provides = 'visiosoft.module.paying::card_save_provider.craftgate';

    /*
     * Save card to database and also send to craftgate
     *
     * params: $userId, $cardHolderName, $cardNumber, $expireYear, $expireMonth, $cardAlias, $cardUserKey
     * return: object
     */
    public function save($cardHolderName, $cardNumber, $expireYear, $expireMonth, $cardAlias = null, $cardUserKey = null)
    {
        try {

            return $this->getProvider()->createCard($cardHolderName, $cardNumber, $expireYear, $expireMonth, $cardAlias, $cardUserKey);

        } catch (\Exception $e) {

            $this->logError($e);

            return $e->getMessage();

        }
    }

    /*
     * Get users all cards from database
     *
     * return: object
     */
    public function getUserCards()
    {
        try {

            return $this->getProvider()->retrieveUserCards();

        } catch (\Exception $e) {

            $this->logError($e);

            return $e->getMessage();

        }
    }

    /*
     * Get default card from database
     *
     * return: object
     */
    public function getDefaultCard()
    {
        try {

            return $this->getProvider()->retrieveDefaultCard();

        } catch (\Exception $e) {

            $this->logError($e);

            return $e->getMessage();

        }
    }

    /*
     * Get default card from database
     *
     * params: $cardID
     *
     * return: object
     */
    public function updateDefaultCard($cardID)
    {
        try {

            return $this->getProvider()->updateDefaultCard($cardID);

        } catch (\Exception $e) {

            $this->logError($e);

            return $e->getMessage();

        }
    }

    /*
     * Delete card from database and also send delete request to craftgate
     *
     * params: $cardID
     * return: boolean
     */
    public function deleteCard($cardID)
    {
        try {

            return $this->getProvider()->deleteCard($cardID);

        }
        catch (\Exception $e) {

            $this->logError($e);

            return $e->getMessage();

        }
    }


    /*
     * Get Card Provider instance from CardProvider class
     *
     * params: $userId
     * return: object
     */
    public function getProvider()
    {
        try {

            return new CardProvider();

        } catch (\Exception $e) {

            $this->logError($e);

            return $e->getMessage();

        }
    }

    /*
     * Logging errors to storage folder
     *
     * params: $error
     * return: void
     */
    public function logError($error)
    {
        return $this->getProvider()->logError($error);
    }

}
