<?php namespace Visiosoft\CraftgateExtension;

use Anomaly\Streams\Platform\Addon\Extension\Extension;
use Visiosoft\CraftgateExtension\Commands\CardProvider;

class CraftgateExtension extends Extension
{
    protected $provides = 'visiosoft.module.payment::save_and_pay_provider.craftgate';

    public function payBySavedCard(
        $providerUserID,
        $defaultCardID,
        $price,
        $currency = '',
        $items = [],
        $buyer = [],
        $invoice_id = '')
    {

        try {

            $response = $this->getProvider()->payBySavedCard($providerUserID, $defaultCardID, $price, $currency, $items, $buyer, $invoice_id);
            $serviceResponse = [];

            if (isset($response->data) && $response->data->paymentStatus == 'SUCCESS') {
                $serviceResponse['status'] = 'success';
                $serviceResponse['payment_intent_id'] = $response->data->id;
            } else if (isset($response->errors)) {
                $serviceResponse['status'] = "fail";
                $serviceResponse['service_message'] = $response->errors->errorDescription;
                $serviceResponse['error_code'] = $response->errors->errorCode;
            } else {
                $serviceResponse['status'] = 'fail';
                $serviceResponse['service_message'] = trans('visiosoft.extension.craftgate::message.unknown_reason');
                $serviceResponse['error_code'] = trans('visiosoft.extension.craftgate::message.unknown');
            }

            return $serviceResponse;
        } catch (\Exception $e) {

            $this->logError($e);
            return $e->getMessage();

        }
    }

    /**
     * @param string $paymentIntentID
     * @param string $paymentID
     * @return array|bool
     */
    public function refund(string $paymentIntentID, string $paymentID)
    {
        try {
            $response = $this->getProvider()->refund($paymentIntentID, (string)$paymentID);
            if (isset($response->data) && $response->data->status === "SUCCESS") {
                return ['status' => "success"];
            }

        } catch (\Exception $e) {
            $this->logError($e);
        }

        return false;

    }

    /*
     * Save card to database and also send to craftgate
     *
     * params: $cardHolderName, $cardNumber, $expireYear, $expireMonth, $cardAlias, $cardUserKey
     * return: object
     */
    public function createCard(
        $cardHolderName,
        $cardNumber,
        $expireYear,
        $expireMonth,
        $cvc = null,
        $email = null,
        $cardUserKey = null,
        $cardAlias = null)
    {

        try {

            $response = $this->getProvider()
                ->createCard(
                    $cardHolderName,
                    $cardNumber,
                    $expireYear,
                    $expireMonth,
                    $cvc,
                    $email,
                    $cardUserKey,
                    $cardAlias);

            if (isset($response->data) && $response->data) {

                return $this->format(
                    $response->data->cardUserKey,
                    $response->data->cardExpiryStatus,
                    $response->data->lastFourDigits,
                    $response->data->cardToken,
                    $response->data->cardAssociation ?? null
                );

            }


            return false;
        } catch (\Exception $e) {

            $this->logError($e);
            return false;

        }

    }

    /*
     * Delete card from database and also send delete request to craftgate
     *
     * params: $cardID
     * return: boolean
     */
    public function removeCard($cardToken)
    {
        try {

            return $this->getProvider()->removeCard($cardToken);

        } catch (\Exception $e) {

            $this->logError($e);

            return false;

        }
    }


    /*
     * Get Card Provider instance from CardProvider class
     *
     * params: $userId
     * return: object
     */
    public function getProvider()
    {
        try {

            return new CardProvider();

        } catch (\Exception $e) {

            $this->logError($e);

            return $e->getMessage();

        }
    }

    /*
     * Logging errors to storage folder
     *
     * params: $error
     * return: void
     */
    public function logError($error)
    {
        return $this->getProvider()->logError($error);
    }

    /*
     * Formatting card info according to the structure
     */
    public function format($cardUserKey, $cardExpiryStatus, $lastFourDigits, $cardToken, $cardAssociation = null)
    {

        // null fields are not returning from craftgate
        return [
            'service_payment_method_id' => $cardToken,
            'service' => 'craftgate',
            'customer' => $cardUserKey,
            'card' => [
                'brand' => $cardAssociation,
                'exp_month' => null,
                'exp_year' => null,
                'expired' => $cardExpiryStatus,
                'last4' => $lastFourDigits,
                'token' => $cardToken
            ]
        ];

    }

}
