<?php namespace Visiosoft\CraftgateExtension;

use Anomaly\Streams\Platform\Addon\Extension\Extension;
use Visiosoft\CraftgateExtension\Commands\CardProvider;

class CraftgateExtension extends Extension
{
    protected $provides = null;

    public function save($userId, $cardHolderName, $cardNumber, $expireYear, $expireMonth, $cardAlias = null, $cardUserKey = null)
    {
        return $this->getProvider()->createCard($userId, $cardHolderName, $cardNumber, $expireYear, $expireMonth, $cardAlias, $cardUserKey);
    }

    /*
     * params: $userId, $cardHolderName, $cardNumber, $expireYear, $expireMonth, $cardAlias, $cardUserKey
     * return: object
     */

    public function update($userId, $cardToken, $expireYear, $expireMonth)
    {
        return $this->getProvider()->updateCard($userId, $cardToken, $expireYear, $expireMonth);
    }

    /*
     * params: $userId, $cardToken, $expireYear, $expireMonth
     * return: object
     */

    public function getUserCards($userId)
    {
        return $this->getProvider()->retrieveUserCards($userId);
    }

    /*
     * params: $userId
     * return: object
     */

    public function getProvider()
    {
        return new CardProvider();
    }
}
