<?php namespace Visiosoft\CraftgateExtension\Commands;


use Craftgate\Craftgate;

class Payment
{
    /**
     * @var Craftgate|null
     */
    protected $craftgate = null;

    /**
     * The informations of craftgate instance.
     *
     * @var string
     */
    public function __construct()
    {
        $this->craftgate = new Craftgate(array(
            'apiKey' => setting_value('visiosoft.extension.payment_craftgate::api_key'),
            'secretKey' => setting_value('visiosoft.extension.payment_craftgate::secret_key'),
            'baseUrl' => setting_value('visiosoft.extension.payment_craftgate::base_url'),
        ));
    }

    /*
     * Create a card
     *
     * @param string $cardHolderName
     * @param string $cardNumber
     * @param string $expireYear
     * @param string $expireMonth
     * @param string $cardAlias
     *
     * return object
     */
    public function createCard($cardHolderName, $cardNumber, $expireYear, $expireMonth, $cardAlias = null, $cardUserKey = null)
    {

        try {
            return $this->craftgate->payment()->storeCard([
                'cardHolderName' => $cardHolderName,
                'cardNumber' => $cardNumber,
                'expireYear' => $expireYear,
                'expireMonth' => $expireMonth,
                'cardAlias' => $cardAlias,
                'cardUserKey' => $cardUserKey
            ]);
        } catch (\Exception $e) {
            return $e->getMessage();
        }

    }

    /*
     * Update card expire date
     *
     * @param string $cardUserKey
     * @param string $cardToken
     * @param string $expireYear
     * @param string $expireMonth
     *
     * return object
     */
    public function updateCard($cardUserKey, $cardToken, $expireYear, $expireMonth)
    {
        try {
            return $this->craftgate->payment()->updateCard([
                'cardUserKey' => $cardUserKey,
                'cardToken' => $cardToken,
                'expireYear' => $expireYear,
                'expireMonth' => $expireMonth
            ]);
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }

    /*
     * Delete a card
     *
     * @param string $cardUserKey
     * @param string $cardToken
     *
     * return null
     */
    public function deleteCard($cardUserKey, $cardToken)
    {
        try {

            if ($cardDelete = $this->craftgate->payment()->deleteStoredCard([
                'cardUserKey' => $cardUserKey,
                'cardToken' => $cardToken])) {
                throw new \Exception($cardDelete);
            } else {
                return true;
            }

        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }

    /*
     * Retrieve a card by cardUserKey and cardToken
     *
     * @param string $cardUserKey
     * @param string $cardToken
     *
     * return object
     */
    public function retrieveCardByKeyAndToken($cardUserKey, $cardToken)
    {

        try {
            return $this->craftgate->payment()->searchStoredCards([
                'cardUserKey' => $cardUserKey,
                'cardToken' => $cardToken
            ]);
        } catch (\Exception $e) {
            return $e->getMessage();
        }

    }

    /*
     * Retrieve all stored cards
     *
     * @param int $page
     * @param int $size
     *
     * return object
     */
    public function retrieveCards($page = 1, $size = 10)
    {

        try {
            return $this->craftgate->payment()->searchStoredCards([
                'page' => $page,
                'size' => $size
            ]);
        } catch (\Exception $e) {
            return $e->getMessage();
        }

    }

}