<?php namespace Visiosoft\CoursefinderTheme;

use Anomaly\PagesModule\Type\TypeRepository;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterFaqEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class CoursefinderThemeSeeder extends Seeder
{
    private $streamRepository;
    private $fieldRepository;
    private $assignmentRepository;
    private $typeRepository;

    public function __construct(
        StreamRepositoryInterface     $streamRepository,
        FieldRepositoryInterface      $fieldRepository,
        AssignmentRepositoryInterface $assignmentRepository,
        TypeRepository                $typeRepository
    )
    {
        parent::__construct();
        $this->streamRepository = $streamRepository;
        $this->fieldRepository = $fieldRepository;
        $this->assignmentRepository = $assignmentRepository;
        $this->typeRepository = $typeRepository;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        if (!$repeater = $this->streamRepository->findBySlugAndNamespace('faq', 'repeater')) {
            $repeater = $this->streamRepository->create([
                'name' => 'FAQ',
                'namespace' => 'repeater',
                'slug' => 'faq',
                'prefix' => 'repeater_',
                'translatable' => true,
            ]);
        }

        $fields = [
            'question_text' => [
                'name' => 'Question Text',
                'namespace' => 'repeater',
                'slug' => 'question_text',
                'type' => 'anomaly.field_type.text',
                'config' => [
                    'type' => 'text',
                    'max' => 255,
                ],
                'assignment_config' => [
                    'required' => true,
                    'translatable' => true,
                ],
            ],
            'answer_text' => [
                'name' => 'Answer Text',
                'namespace' => 'repeater',
                'slug' => 'answer_text',
                'type' => 'anomaly.field_type.text',
                'config' => [
                    'type' => 'text',
                    'max' => 255,
                ],
                'assignment_config' => [
                    'required' => true,
                    'translatable' => true,
                ],
            ]
        ];

        foreach ($fields as $field) {
            if (!$this->fieldRepository->findBySlugAndNamespace($field['slug'], $field['namespace'])) {
                $entry = $this->fieldRepository->create([
                    'name' => $field['name'],
                    'slug' => $field['slug'],
                    'namespace' => $field['namespace'],
                    'type' => $field['type'],
                    'config' => $field['config'],
                    'locked' => 0,
                ]);

                $this->assignmentRepository->create([
                    'stream_id' => $repeater->getId(),
                    'field_id' => $entry->getId(),
                    'label' => $field['name'],
                ]);
            }
        }

        if (!$this->fieldRepository->findBySlugAndNamespace('faq', 'pages')) {
            $this->fieldRepository->create([
                'name' => 'FAQ',
                'slug' => 'faq',
                'namespace' => 'pages',
                'type' => 'anomaly.field_type.repeater',
                'locked' => 0,
                'config' => [
                    'related' => RepeaterFaqEntryModel::class,
                ]
            ]);
        }

        if ($pageType = $this->typeRepository->findBySlug('default')) {
            $stream = $pageType->getEntryStream();
            $this->assignmentRepository->create([
                'stream' => $stream,
                'field' => $this->fields->findBySlugAndNamespace('faq', 'pages')
            ]);
        }
    }
}
