<?php namespace Visiosoft\CouponModule\Coupon\Command;

use Visiosoft\CouponModule\Coupon\Contract\CouponRepositoryInterface;
use Visiosoft\CouponModule\Coupon\Traits\executeDiscount;

class calculateTotal
{
    use executeDiscount;


    protected $code;

    public function __construct($code)
    {
        $this->code = $code;
    }

    public function handle(CouponRepositoryInterface $repository)
    {
        if ($coupons = $repository->getCodelessCoupons()) {

            $total_discount_amount = 0;

            foreach ($coupons as $coupon) {
                $discount_amount = $this->execute($coupon);
                $total_discount_amount += $discount_amount;
            }

            return $total_discount_amount;
        }
    }
}
