<?php namespace Visiosoft\CouponModule\Code\CartsForm;

use Anomaly\Streams\Platform\Message\MessageBag;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\Auth;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CouponModule\Code\Contract\CodeRepositoryInterface;

class CartsFormHandler
{
    use DispatchesJobs;

    public function handle(CartsFormBuilder $builder, CodeRepositoryInterface $repository, MessageBag $messageBag)
    {
        if (!$builder->canSave()) {
            return;
        }

        $status = true;

        $code = $builder->getPostValue('coupon_code');


        if ($coupon = $repository->findByCode($code)) {
            $group = $coupon->getGroup();

            $type = $group->getType();

            $entries = $group->getEntries();

            $entry_model = $type->getEntryModel();

            $cart = $this->dispatch(new GetCart());


            //Check Expiry
            if ($coupon->expiry_at and $coupon->expiry_at < now()) {
                $status = false;
            }

            //Check Min Price
            if ($min = $coupon->min_price and $min > $cart->total) {
                $status = false;
            }


            if ($status and count($entries)) {
                if ($type->slug == 'users' and $type->namespace == "users") {
                    if (in_array(Auth::id(), $entries)) {
                        $this->calculateCart($coupon->value, $coupon->is_percent);
                    }
                }
            }
            $messageBag->success(trans('visiosoft.module.coupon::message.applied_coupon'));
        } else {
            $messageBag->error(trans('visiosoft.module.coupon::message.found_code'));
        }
    }

    public function calculateCart($discount, $is_percent = false)
    {
        $cart = $this->dispatch(new GetCart());

        if ($cart->discounts == "0.00") {
            if ($is_percent) {
                $discount = ($cart->getTotal() * $discount) / 100;
            }

            $cart->setAttribute('discounts', $discount);
            $cart->setAttribute('total', $cart->getTotal() - $cart->getDiscounts());
            $cart->save();
        }

        return $cart;
    }
}
