<?php namespace Visiosoft\CouponModule\UsedCoupon;

use Visiosoft\CouponModule\UsedCoupon\Contract\UsedCouponRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class UsedCouponRepository extends EntryRepository implements UsedCouponRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var UsedCouponModel
     */
    protected $model;

    /**
     * Create a new UsedCouponRepository instance.
     *
     * @param UsedCouponModel $model
     */
    public function __construct(UsedCouponModel $model)
    {
        $this->model = $model;
    }

    public function findByCouponId($coupon_id)
    {
        return $this->findBy('coupon_id', $coupon_id);
    }
}
