<?php namespace Visiosoft\CouponModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Support\Facades\Cookie;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CouponModule\Code\Contract\CodeRepositoryInterface;

class CouponController extends PublicController
{
    public function autoApplyCoupon(
        CodeRepositoryInterface $codeRepository,
        AdvModel $advModel,
        $code
    )
    {
        try {
            $code = explode('-', $code);

            if (count($code) < 2) {
                throw new \Exception(trans('visiosoft.module.coupon::message.code_format_is_not_correct'));
            }

            $code = $codeRepository->newQuery()->where([
                'code' => $code[1],
                'coupon_id' => $code[0],
            ])->first();

            if (!$code) {
                throw new \Exception(trans('visiosoft.module.coupon::message.code_not_found'));
            }

            if (!$coupon = $code->coupon) {
                throw new \Exception(trans('visiosoft.module.coupon::message.coupon_not_found'));
            }

            if ($coupon->isClassifiedCoupon()) {
                $ids = json_decode($coupon->type_entry_json);

                foreach ($ids as $id) {
                    $classified = $advModel->isAdv($id);

                    if ($classified && $classified->getStatus() == "approved") {
                        $advModel->addCart($classified);
                    }
                }
            }

            Cookie::queue(Cookie::make('coupon_code', $code->code, 84000));

            return redirect()->route('visiosoft.module.carts::cart');
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());

            return redirect('/');
        }
    }
}
