<?php namespace Visiosoft\CouponModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Maatwebsite\Excel\Facades\Excel;
use Visiosoft\CouponModule\Code\Exports\CodesExport;
use Visiosoft\CouponModule\Coupon\CouponModel;
use Visiosoft\CouponModule\Coupon\Form\Command\AddEntryField;
use Visiosoft\CouponModule\Coupon\Form\CouponFormBuilder;
use Visiosoft\CouponModule\Coupon\Table\CouponTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class CouponController extends AdminController
{
    public function index(CouponTableBuilder $table)
    {
        return $table->render();
    }

    public function choose(StreamRepositoryInterface $streamRepository)
    {
        $streams = $streamRepository->all();
        $entryTypes = array();
        $activeStreams = CouponModel::$couponableStreams;

        foreach ($activeStreams as $stream) {
            if ($stream = $streams->where('namespace', $stream['namespace'])->where('slug', $stream['slug'])->first()) {
                $entryTypes[$stream->getId()] = trans($stream->name);
            }
        }

        return $this->view->make(
            'module::admin/coupon/choose',
            [
                'types' => $entryTypes,
            ]
        );
    }

    public function create(CouponFormBuilder $form)
    {
        $this->dispatch(new AddEntryField($form));

        return $form->render();
    }

    public function getStreamEntryAjax(StreamRepositoryInterface $streamRepository, $stream_id)
    {
        $response = [
            'status' => false,
            'entries' => []
        ];

        if ($stream = $streamRepository->find($stream_id)) {

            $entry_model = $stream->getEntryModel();

            $title_columns = [
                'users' => 'email',
                'store' => 'name',
            ];

            $title_column = $entry_model->getTitleName();

            $namespace = $stream->getNamespace();

            if (array_key_exists($namespace, $title_columns)) {
                $title_column = $title_columns[$namespace];
            }

            if ($namespace == "cats") {
                $all_entry = $entry_model
                    ->where('parent_category_id', null)
                    ->withTrans()
                    ->orderBy('sort_order');
            } elseif ($namespace == 'store') {
                $all_entry = $entry_model
                    ->withTrans();
            } else {
                $all_entry = $entry_model;
            }

            if ($term = request('term')) {
                $all_entry = $all_entry->where($title_column, 'LIKE', "%$term%");
            }

            $all_entry = $all_entry->limit(10)->get();

            $entries = [];

            if ($all_entry) {
                foreach ($all_entry->pluck($title_column, 'id')->all() as $entry_id => $entry_title) {
                    $entry = [
                        'id' => strval($entry_id),
                        'text' => $entry_title
                    ];

                    $entries[] = $entry;
                }
            }


            $response['status'] = true;
            $response['entries'] = $entries;
        }

        return response()->json($response);
    }

    public function download($couponID)
    {
        return Excel::download(new CodesExport($couponID), 'codes.xlsx');
    }
}
