<?php namespace Visiosoft\CouponModule\Coupon\Form;

class CouponFormHandler
{
    public function handle(CouponFormBuilder $builder)
    {
        if (!$builder->canSave()) {
            return;
        }

        $couponTypeEntry = $builder->getFormField('coupon_type_entry');
        $couponTypeEntry = $couponTypeEntry ? $couponTypeEntry->getValue() : false;
        $builder->disableFormField('coupon_type_entry');

        $noOfCodes = $builder->getFormField('no_of_codes');
        $noOfCodes = $noOfCodes ? $noOfCodes->getValue() : false;
        $builder->disableFormField('no_of_codes');

        $builder->saveForm();

        $entry = $builder->getFormEntry();

        if ($noOfCodes) {
            $entry->generateCodes($noOfCodes);
        }

        if (is_array($couponTypeEntry)) {
            $entry->setAttribute('type_entry_json', json_encode($couponTypeEntry));
            $entry->save();
        }
    }
}
