<?php namespace Visiosoft\CouponModule\Coupon;

use Visiosoft\CouponModule\Code\Contract\CodeRepositoryInterface;
use Visiosoft\CouponModule\Coupon\Contract\CouponRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class CouponRepository extends EntryRepository implements CouponRepositoryInterface
{
    /**
     * The entry model.
     *
     * @var CouponModel
     */
    protected $model;

    /**
     * Create a new CouponRepository instance.
     *
     * @param CouponModel $model
     */
    public function __construct(CouponModel $model)
    {
        $this->model = $model;
    }

    public function findByCode($code)
    {
        if (!$code) {
            return $this->newQuery()->doesntHave('codes')->first();
        }

        $codeRepository = app(CodeRepositoryInterface::class);

        $code_entry = $codeRepository->newQuery()
            ->where('code', $code)
            ->first();

        if ($code_entry) {
            return $this->newQuery()->find($code_entry->coupon_id);
        }

        return null;
    }

    public function getCodelessCoupons()
    {
        return $this->newQuery()->doesntHave('codes')->get();
    }
}
