<?php namespace Visiosoft\CouponModule\Coupon\Command;

use Visiosoft\CouponModule\Coupon\Contract\CouponRepositoryInterface;
use Visiosoft\CouponModule\Coupon\Traits\executeDiscount;

class calculateTotalWithCouponCode
{
    use executeDiscount;

    protected $code;

    public function __construct($code)
    {
        $this->code = $code;
    }

    public function handle(CouponRepositoryInterface $repository)
    {
        if ($coupon = $repository->findByCode($this->code)) {

            $discount_amount = $this->execute($coupon);

            return $discount_amount;
        }
    }

}
