<?php namespace Visiosoft\CouponModule\Coupon\CartsForm;

use Anomaly\Streams\Platform\Message\MessageBag;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;
use Visiosoft\CouponModule\Coupon\Contract\CouponRepositoryInterface;
use Visiosoft\CouponModule\UsedCoupon\Contract\UsedCouponRepositoryInterface;

class CartsFormHandler
{
    use DispatchesJobs;

    public function handle(CartsFormBuilder $builder, UsedCouponRepositoryInterface $usedCouponRepository, CouponRepositoryInterface $repository, MessageBag $messageBag)
    {
        if (!$builder->canSave()) {
            return;
        }

        $code = $builder->getPostValue('coupon_code');


        if ($coupon = $repository->findByCode($code)) {

            //Check Auth Used
            if ($coupon->used_only_once
                and $usedCoupon = $usedCouponRepository->findByCouponId($coupon->getId())
                and $usedCoupon->user_id == Auth::id()) {
                $messageBag->error(trans('visiosoft.module.coupon::message.coupon_only_used_error'));
            } else {

                Cookie::queue(Cookie::make('coupon_code', $code, 84000));

                $messageBag->success(trans('visiosoft.module.coupon::message.applied_coupon'));
            }
        } else {
            $messageBag->error(trans('visiosoft.module.coupon::message.found_code'));
        }
    }
}
