<?php namespace Visiosoft\CouponModule\Group\EntryForm;

use Anomaly\MultipleFieldType\MultipleFieldType;

class GroupEntryFormFields
{
    public function handle(GroupEntryFormBuilder $builder)
    {

        $stream = $builder->getFormEntry();

        $type = $stream->getType();

        $entry_model = $type->getEntryModel();

        $title_columns = [
            'users' => 'email',
            'store' => 'name',
        ];

        $builder->setFields([
            'entry' => [
                'type' => 'anomaly.field_type.multiple',
                "value" => function () use ($stream) {
                    return $stream->getEntries();
                },
                'config' => [
                    "handler" => function (MultipleFieldType $fieldType) use ($entry_model, $type, $title_columns) {
                        $title_column = $entry_model->getTitleName();

                        $namespace = $type->getNamespace();

                        if (array_key_exists($namespace, $title_columns)) {
                            $title_column = $title_columns[$namespace];
                        }

                        $all_entry = $entry_model->get();

                        if ($namespace == "cats") {
                            $all_entry = $entry_model->get()->mainCategories();
                        }

                        $fieldType->setOptions($all_entry->pluck($title_column, 'id')->all());
                    },

                ],
            ],
        ]);
    }
}
