<?php namespace Visiosoft\CouponModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\CouponModule\Code\CartsForm\CartsFormBuilder;
use Visiosoft\CouponModule\Code\Contract\CodeRepositoryInterface;
use Visiosoft\CouponModule\Code\CodeRepository;
use Anomaly\Streams\Platform\Model\Coupon\CouponCodeEntryModel;
use Visiosoft\CouponModule\Code\CodeModel;
use Visiosoft\CouponModule\Group\Contract\GroupRepositoryInterface;
use Visiosoft\CouponModule\Group\GroupRepository;
use Anomaly\Streams\Platform\Model\Coupon\CouponGroupEntryModel;
use Visiosoft\CouponModule\Group\GroupModel;
use Illuminate\Routing\Router;

class CouponModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/coupon/code'           => 'Visiosoft\CouponModule\Http\Controller\Admin\CodeController@index',
        'admin/coupon/code/create'    => 'Visiosoft\CouponModule\Http\Controller\Admin\CodeController@create',
        'admin/coupon/code/edit/{id}' => 'Visiosoft\CouponModule\Http\Controller\Admin\CodeController@edit',
        'admin/coupon' => 'Visiosoft\CouponModule\Http\Controller\Admin\GroupController@index',
        'admin/coupon/create' => 'Visiosoft\CouponModule\Http\Controller\Admin\GroupController@create',
        'admin/coupon/edit/{id}' => 'Visiosoft\CouponModule\Http\Controller\Admin\GroupController@edit',
        'admin/coupon/edit-entry/{id}' => [
            'as' => 'visiosoft.module.coupon::edit-entry',
            'uses' => 'Visiosoft\CouponModule\Http\Controller\Admin\GroupController@addEntry',
        ],
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\CouponModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\CouponModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\CouponModule\Event\ExampleEvent::class => [
        //    Visiosoft\CouponModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\CouponModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        CouponCodeEntryModel::class => CodeModel::class,
        CouponGroupEntryModel::class => GroupModel::class,
        'coupon_form' => CartsFormBuilder::class
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        CodeRepositoryInterface::class => CodeRepository::class,
        GroupRepositoryInterface::class => GroupRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
