<?php namespace Visiosoft\CouponModule\Code\Traits;


use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\Auth;
use Visiosoft\CartsModule\Cart\Command\GetCart;

trait executeDiscount
{
    use DispatchesJobs;

    public function execute($coupon)
    {

        $group = $coupon->getGroup();

        $type = $group->getType();

        $entries = $group->getEntries();

        $entry_model = $type->getEntryModel();

        $cart = $this->dispatch(new GetCart());

        $status = true;


        //Check Expiry
        if ($coupon->expiry_at and $coupon->expiry_at < now()) {
            $status = false;
        }

        //Check Min Price
        if ($min = $coupon->min_price and $min > $cart->total) {
            $status = false;
        }

        $discount_amount = 0;

        if ($status) {
            if ($entries and count($entries)) {
                if ($type->slug == 'users' and $type->namespace == "users") {
                    if (in_array(Auth::id(), $entries)) {
                        $discount_amount = $this->calculateCart($cart->total, $coupon);
                    }
                } else if ($type->slug == 'advs' and $type->namespace == "advs") {

                    if ($coupon->price_discount_type == "apply_to_cart") {
                        $discount_amount = $this->calculateCart($cart->total, $coupon);
                    } else {
                        foreach ($cart->items as $item) {
                            $id = $item->entry_id;
                            if (in_array($id, $entries)) {
                                $discount_amount += $this->calculateCart($item->total, $coupon);
                            }
                        }
                    }
                } else if ($type->slug == 'category' and $type->namespace == "cats") {
                    foreach ($cart->items as $item) {
                        $item_entry = $item->entry;
                        if (in_array($item_entry->cat1, $entries)) {

                            if ($coupon->price_discount_type == "apply_to_cart") {
                                $discount_amount = $this->calculateCart($cart->total, $coupon);
                                break;
                            } else {
                                $discount_amount += $this->calculateCart($item->total, $coupon);
                            }
                        }
                    }
                } else if ($type->slug == 'store' and $type->namespace == "store") {

                    //brings the owners of the items in the carts
                    $cart_item_owners = [];
                    foreach ($cart->items as $item) {
                        if ($item->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                            $cart_item_owners[] = $item->entry->created_by_id;
                        }
                    }
                    $cart_item_owners = array_unique($cart_item_owners);

                    //bring in store users
                    $store_users = [];
                    foreach ($entries as $entry) {
                        if ($store = $entry_model->find($entry)) {
                            $users = $store->getStoreUsers()->pluck('id')->all();
                            $store_users = array_merge($store_users, $users);
                        }
                    }
                    $store_users = array_unique($store_users);

                    if ($coupon->price_discount_type == "apply_to_cart") {
                        if (count(array_intersect($cart_item_owners, $store_users))) {
                            $discount_amount = $this->calculateCart($cart->total, $coupon);
                        }
                    } else {
                        foreach ($cart->items as $item) {
                            $created_id = $item->entry->created_by_id;
                            if (in_array($created_id, $store_users)) {
                                $discount_amount += $this->calculateCart($item->total, $coupon);
                            }
                        }
                    }
                }
            } else {
                $discount_amount = $this->calculateCart($cart->total, $coupon);
            }
        }

        return $discount_amount;
    }

    public function calculateCart($price, $coupon)
    {
        if ($coupon->is_percent) {
            $discount = ($price * $coupon->value) / 100;
        } else {
            $discount = $coupon->value;
        }
        
        return $discount;
    }
}