<?php namespace Visiosoft\CouponModule\Code\Command;

use Visiosoft\CouponModule\Code\Contract\CodeRepositoryInterface;
use Visiosoft\CouponModule\Code\Traits\executeDiscount;

class calculateTotalWithCouponCode
{
    use executeDiscount;

    protected $code;

    public function __construct($code)
    {
        $this->code = $code;
    }

    public function handle(CodeRepositoryInterface $repository)
    {
        if ($coupon = $repository->findByCode($this->code)) {

            $discount_amount = $this->execute($coupon);

            return $discount_amount;
        }
    }

}
