<?php namespace Visiosoft\CouponModule\Code\Command;

use Visiosoft\CouponModule\Code\Contract\CodeRepositoryInterface;
use Visiosoft\CouponModule\Code\Traits\executeDiscount;

class calculateTotal
{
    use executeDiscount;


    protected $code;

    public function __construct($code)
    {
        $this->code = $code;
    }

    public function handle(CodeRepositoryInterface $repository)
    {
        if ($coupons = $repository->findAllBy('code', null)) {

            $total_discount_amount = 0;

            foreach ($coupons as $coupon) {
                $discount_amount = $this->execute($coupon);
                $total_discount_amount += $discount_amount;
            }

            return $total_discount_amount;
        }
    }
}
