<?php namespace Visiosoft\CouponModule\Coupon;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Visiosoft\CouponModule\Code\CodeModel;
use Visiosoft\CouponModule\Coupon\Contract\CouponInterface;
use Anomaly\Streams\Platform\Model\Coupon\CouponCouponEntryModel;

class CouponModel extends CouponCouponEntryModel implements CouponInterface
{
    public static $couponableStreams = [
        [
            'slug' => 'users',
            'namespace' => 'users',
        ],
        [
            'slug' => 'advs',
            'namespace' => 'advs',
        ],
        [
            'slug' => 'store',
            'namespace' => 'store',
        ],
        [
            'slug' => 'category',
            'namespace' => 'cats',
        ],
    ];

    public function codes()
    {
        return $this->hasMany(CodeModel::class, 'coupon_id');
    }

    public function hasCodes()
    {
    return $this->codes->count() > 0;
    }

    public function getCouponTypeEntries()
    {
        return json_decode($this->entry_json, true);
    }

    public function getType()
    {
        return $this->coupon_type;
    }

    public function isClassifiedCoupon()
    {
        return $this->getType()->slug === 'advs';
    }

    public function generateCodes($numberOfCodes = 1)
    {
        $createdAt = Carbon::now();
        $generatedCodes = array();

        for ($i = 0; $i < $numberOfCodes; $i++) {
            while (!in_array(($generatedCode = Str::random()), $generatedCodes)) {
                $generatedCodes[] = strtoupper($generatedCode);
                break;
            }
        }

        foreach ($generatedCodes as $index => $code) {
            $generatedCodes[$index] = [
                'code' => $code,
                'coupon_id' => $this->id,
                'created_at' => $createdAt,
            ];
        }

        $generatedCodes = collect($generatedCodes);
        $chunks = $generatedCodes->chunk(500);

        foreach ($chunks as $chunk) {
            DB::table('coupon_codes')->insert($chunk->toArray());
        }

        return true;
    }

    public function deleteCodes()
    {
        return $this->codes()->delete();
    }
}
