<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleCouponCreateCodesFields extends Migration
{
    public function up()
    {
        $couponModel = $this->streams()->findBySlugAndNamespace('coupon', 'coupon')->getEntryModel();
        $codeModel = $this->streams()->findBySlugAndNamespace('codes', 'coupon')->getEntryModel();

        $coupons = $couponModel->newQuery()->whereNotNull('coupon_code')->orderBy('id')->get();

        $coupons->each(function ($coupon) use ($codeModel) {
            $codeModel->create([
                'code' => $coupon->coupon_code,
                'coupon_id' => $coupon->id,
            ]);
        });

        if ($field = $this->fields()->findBySlugAndNamespace('coupon_code', 'coupon')) {
            $field->delete();
        }
    }

    public function down()
    {
        if (!$this->fields()->findBySlugAndNamespace('coupon_code', 'coupon')) {
            $stream = $this->streams()->findBySlugAndNamespace('coupon', 'coupon');

            $field = $this->fields()->create([
                'namespace' => 'coupon',
                'slug' => 'coupon_code',
                'type' => 'anomaly.field_type.text',
                'locked' => true,
                'name' => 'visiosoft.module.coupon::field.codes.name',
                'placeholder' => 'visiosoft.module.coupon::field.codes.placeholder',
                'warning' => 'visiosoft.module.coupon::field.codes.warning',
                'instructions' => 'visiosoft.module.coupon::field.codes.instructions',
            ]);

            $this->assignments()->create([
                'stream_id' => $stream->getId(),
                'field_id' => $field->id,
                'label' => 'visiosoft.module.coupon::field.coupon_code.label.coupon',
                'warning' => 'visiosoft.module.coupon::field.coupon_code.warning.coupon',
                'placeholder' => 'visiosoft.module.coupon::field.coupon_code.placeholder.coupon',
                'instructions' => 'visiosoft.module.coupon::field.coupon_code.instructions.coupon',
            ]);
        }
    }
}
