<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleCouponCreateCodeStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'code',
        'title_column' => 'code',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'group' => [
            'required' => true,
        ],
        'expiry_at',
        'min_price' => [
            'required' => true,
        ],
        'is_percent',
        'code' => [
            'unique' => true,
        ],
        'value' => [
            'required' => true,
        ],
    ];

}
