<?php namespace Visiosoft\CouponModule\Coupon\Listeners;

use Illuminate\Support\Facades\Auth;
use Visiosoft\CouponModule\Coupon\Contract\CouponRepositoryInterface;
use Visiosoft\CouponModule\UsedCoupon\Contract\UsedCouponRepositoryInterface;
use Visiosoft\OrdersModule\Events\OrderCreated;

class UsedCouponForCreatedOrder
{
    use \Visiosoft\CartsModule\Cart\Traits\calculateTotal;

    protected $couponRepository;
    protected $usedCouponRepository;

    public function __construct(CouponRepositoryInterface $couponRepository, UsedCouponRepositoryInterface $usedCouponRepository)
    {
        $this->couponRepository = $couponRepository;
        $this->usedCouponRepository = $usedCouponRepository;
    }

    public function handle(OrderCreated $event)
    {
        $calculate = $this->calculateTotal();

        $discount = $calculate['discount'];
        $couponCode = $calculate['couponCode'];

        if ($discount) {
            $coupon = $this->couponRepository->findByCode($couponCode);
            $order = $event->getOrder();

            $this->usedCouponRepository->create([
                'order' => $order,
                'coupon' => $coupon,
                'user' => Auth::user()
            ]);

        }
    }
}