<?php namespace Visiosoft\CouponModule\Group\Form;

use Anomaly\RelationshipFieldType\RelationshipFieldType;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class GroupFormFields
{
    public function handle(GroupFormBuilder $builder)
    {
        $builder->setFields([
            'name',
            'type' => [
                'config' => [
                    "mode" => "search",
                    "handler" => function (RelationshipFieldType $fieldType, StreamRepositoryInterface $streams) {
                        $streams = $streams->newQuery()->get();

                        $entry_types = array();

                        $active_streams = [
                            'users' => 'users',
                            'advs' => 'advs',
                            'store' => 'store',
                            'cats' => 'category',
                        ];
                        foreach ($streams as $stream) {
                            if (array_key_exists($stream->namespace, $active_streams) and in_array($stream->slug, $active_streams)) {
                                $entry_types[$stream->getId()] = trans($stream->name) . "(" . ucfirst($stream->namespace) . ")";
                            }
                        }

                        $fieldType->setOptions($entry_types);
                    }
                ],
            ],
        ]);
    }
}
