<?php namespace Visiosoft\CouponModule\Code\Traits;


use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\Auth;
use Visiosoft\CartsModule\Cart\Command\GetCart;

trait executeDiscount
{
    use DispatchesJobs;

    public function execute($coupon)
    {

        $group = $coupon->getGroup();

        $type = $group->getType();

        $entries = $group->getEntries();

        //$entry_model = $type->getEntryModel();

        $cart = $this->dispatch(new GetCart());

        $status = true;


        //Check Expiry
        if ($coupon->expiry_at and $coupon->expiry_at < now()) {
            $status = false;
        }

        //Check Min Price
        if ($min = $coupon->min_price and $min > $cart->total) {
            $status = false;
        }

        $discount_amount = 0;

        if ($status) {
            if ($entries and count($entries)) {
                if ($type->slug == 'users' and $type->namespace == "users") {
                    if (in_array(Auth::id(), $entries)) {
                        $discount_amount = $this->calculateCart($cart->total, $coupon);
                    }
                } else if ($type->slug == 'advs' and $type->namespace == "advs") {

                    if ($coupon->price_discount_type == "apply_to_cart") {
                        $discount_amount = $this->calculateCart($cart->total, $coupon);
                    } else {
                        foreach ($cart->items as $item) {
                            $id = $item->entry_id;
                            if (in_array($id, $entries)) {
                                $discount_amount += $this->calculateCart($item->total, $coupon);
                            }
                        }
                    }
                } else if ($type->slug == 'category' and $type->namespace == "cats") {
                    foreach ($cart->items as $item) {
                        $item_entry = $item->entry;
                        if (in_array($item_entry->cat1, $entries)) {

                            if ($coupon->price_discount_type == "apply_to_cart") {
                                $discount_amount = $this->calculateCart($cart->total, $coupon);
                                break;
                            } else {
                                $discount_amount += $this->calculateCart($item->total, $coupon);
                            }
                        }
                    }
                }
            } else {
                $discount_amount = $this->calculateCart($cart->total, $coupon);
            }
        }

        return $discount_amount;
    }

    public function calculateCart($price, $coupon)
    {
        if ($coupon->is_percent) {
            $discount = ($price * $coupon->value) / 100;
        } else {
            $discount = $coupon->value;
        }

        return $discount;

    }
}