<?php namespace Visiosoft\CouponModule\Code\CartsForm;

use Anomaly\Streams\Platform\Message\MessageBag;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\Cookie;
use Visiosoft\CartsModule\Modifier\Contract\ModifierRepositoryInterface;
use Visiosoft\CouponModule\Code\Contract\CodeRepositoryInterface;

class CartsFormHandler
{
    use DispatchesJobs;

    public function handle(CartsFormBuilder $builder, CodeRepositoryInterface $repository, MessageBag $messageBag, ModifierRepositoryInterface $modifierRepository)
    {
        if (!$builder->canSave()) {
            return;
        }

        $code = $builder->getPostValue('coupon_code');


        if ($coupon = $repository->findByCode($code)) {

            Cookie::queue(Cookie::make('coupon_code', $code, 84000));

            $messageBag->success(trans('visiosoft.module.coupon::message.applied_coupon'));
        } else {
            $messageBag->error(trans('visiosoft.module.coupon::message.found_code'));
        }
    }
}
