<?php namespace Visiosoft\CouponModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\CouponModule\Code\Contract\CodeRepositoryInterface;
use Visiosoft\CouponModule\Code\CodeRepository;
use Anomaly\Streams\Platform\Model\Coupon\CouponCodesEntryModel;
use Visiosoft\CouponModule\Code\CodeModel;
use Visiosoft\CouponModule\Coupon\CartsForm\CartsFormBuilder;
use Visiosoft\CouponModule\Coupon\Listeners\UsedCouponForCreatedOrder;
use Visiosoft\CouponModule\UsedCoupon\Contract\UsedCouponRepositoryInterface;
use Visiosoft\CouponModule\UsedCoupon\UsedCouponRepository;
use Anomaly\Streams\Platform\Model\Coupon\CouponUsedCouponsEntryModel;
use Visiosoft\CouponModule\UsedCoupon\UsedCouponModel;
use Visiosoft\CouponModule\Coupon\Contract\CouponRepositoryInterface;
use Visiosoft\CouponModule\Coupon\CouponRepository;
use Anomaly\Streams\Platform\Model\Coupon\CouponCouponEntryModel;
use Visiosoft\CouponModule\Coupon\CouponModel;
use Visiosoft\OrdersModule\Events\OrderCreated;

class CouponModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        // Admin CodesController
        'admin/coupon/codes'           => 'Visiosoft\CouponModule\Http\Controller\Admin\CodesController@index',
        'admin/coupon/codes/create'    => 'Visiosoft\CouponModule\Http\Controller\Admin\CodesController@create',
        'admin/coupon/codes/edit/{id}' => 'Visiosoft\CouponModule\Http\Controller\Admin\CodesController@edit',

        // Admin CouponController
        'admin/coupon' => 'Visiosoft\CouponModule\Http\Controller\Admin\CouponController@index',
        'admin/coupon/create' => 'Visiosoft\CouponModule\Http\Controller\Admin\CouponController@create',
        'admin/coupon/edit/{id}' => 'Visiosoft\CouponModule\Http\Controller\Admin\CouponController@edit',
        'admin/coupon/download/{id}' => 'Visiosoft\CouponModule\Http\Controller\Admin\CouponController@download',
        'admin/coupon/get-entries/{stream_id}' => [
            'as' => 'visiosoft.module.coupon::coupon.get_stream_entry_ajax',
            'uses' => 'Visiosoft\CouponModule\Http\Controller\Admin\CouponController@getStreamEntryAjax',
        ],

        // Admin UsedCouponsController
        'admin/coupon/used_coupons' => 'Visiosoft\CouponModule\Http\Controller\Admin\UsedCouponsController@index',

        // CouponController
        'coupon/{code}' => 'Visiosoft\CouponModule\Http\Controller\CouponController@autoApplyCoupon',
    ];

    protected $listeners = [
        OrderCreated::class => [
            UsedCouponForCreatedOrder::class,
        ],
    ];

    protected $bindings = [
        CouponCodesEntryModel::class => CodeModel::class,
        CouponUsedCouponsEntryModel::class => UsedCouponModel::class,
        CouponCouponEntryModel::class => CouponModel::class,
        'coupon_form' => CartsFormBuilder::class
    ];

    protected $singletons = [
        CodeRepositoryInterface::class => CodeRepository::class,
        UsedCouponRepositoryInterface::class => UsedCouponRepository::class,
        CouponRepositoryInterface::class => CouponRepository::class,
    ];
}
