<?php namespace Visiosoft\CouponModule\Coupon;

use Visiosoft\CouponModule\Coupon\Contract\CouponRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class CouponRepository extends EntryRepository implements CouponRepositoryInterface
{
    /**
     * The entry model.
     *
     * @var CouponModel
     */
    protected $model;

    /**
     * Create a new CouponRepository instance.
     *
     * @param CouponModel $model
     */
    public function __construct(CouponModel $model)
    {
        $this->model = $model;
    }

    public function findByCode($code)
    {
        if (!$code) {
            return $this->newQuery()->doesntHave('codes')->first();
        }

        return $this->newQuery()->with('codes', function ($q) use ($code) {
            $q->where('code', $code);
        })->first();
    }

    public function getCodelessCoupons()
    {
        return $this->newQuery()->doesntHave('codes')->get();
    }
}
