<?php namespace Visiosoft\CouponModule\Code\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Visiosoft\CouponModule\Code\Contract\CodeRepositoryInterface;

class CodesExport implements FromCollection
{
    protected $couponID;

    public function __construct($couponID)
    {
        $this->couponID = $couponID;
    }

    public function collection()
    {
        $codeRepository = app(CodeRepositoryInterface::class);
        return $codeRepository->newQuery()
            ->selectRaw("CONCAT(coupon_id, '-', code) as coupon_code")
            ->where('coupon_id', $this->couponID)
            ->get();
    }
}
