<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleCouponCreateCouponStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'coupon',
        'title_column' => 'coupon_name',
        'translatable' => true,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'coupon_name' => [
            'translatable' => true,
            'required' => true,
        ],
        'coupon_type' => [
            'required' => true,
        ],
        'type_entry_json',
        'coupon_expiry_at',
        'min_cart_price' => [
            'required' => true,
        ],
        'discount_type' => [
            'required' => true,
        ],
        'value_discount_type',
        'coupon_code',
        'discount_value' => [
            'required' => true,
        ],
        'used_only_once'
    ];

}
