<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleCouponCreateCouponFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'coupon_name' => 'anomaly.field_type.text',
        'coupon_type' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Anomaly\Streams\Platform\Stream\StreamModel::class,
            ],
        ],
        'type_entry_json' => 'visiosoft.field_type.json',
        'coupon_expiry_at' => 'anomaly.field_type.datetime',
        'min_cart_price' => [
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'default_value' => 0,
                'min' => 0
            ],
        ],
        'discount_type' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                'default_value' => 'fixed_amount',
                'options' => [
                    "percentage" => "visiosoft.module.coupon::field.percentage",
                    "fixed_amount" => "visiosoft.module.coupon::field.fixed_amount",
                ]
            ],
        ],
        'value_discount_type' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                'options' => [
                    'apply_to_cart' => 'visiosoft.module.coupon::button.apply_to_cart',
                    'apply_to_each_products' => 'visiosoft.module.coupon::button.apply_to_each_products'
                ],
                'mode' => 'radio',
                'default_value' => 'apply_to_cart',
            ],
        ],
        'coupon_code' => 'anomaly.field_type.text',
        'discount_value' => [
            'type' => 'visiosoft.field_type.decimal',
            'config' => [
                'decimal' => 2,
                'separator' => '.',
                'point' => ',',
                'min' => 0
            ],
        ],
        'used_only_once' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'mode' => 'checkbox',
                'default_value' => false
            ],
        ],

        //Used Order
        'order' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\OrdersModule\Order\OrderModel::class,
            ],
        ],
        'coupon' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\CouponModule\Coupon\CouponModel::class
            ],
        ],
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Anomaly\UsersModule\User\UserModel::class
            ],
        ],
    ];

}
