<?php namespace Visiosoft\CouponModule\Coupon\Form;

use Anomaly\RelationshipFieldType\RelationshipFieldType;
use Anomaly\Streams\Platform\Entry\EntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Anomaly\Streams\Platform\Support\Collection;

class CouponFormFields
{
    public function handle(CouponFormBuilder $builder)
    {
        $builder->setFields([
            'coupon_name',
            'coupon_type' => [
                'config' => [
                    "mode" => "search",
                    "handler" => function (RelationshipFieldType $fieldType, StreamRepositoryInterface $streams) {
                        $streams = $streams->newQuery()->get();

                        $entry_types = array();

                        $active_streams = [
                            'users' => 'users',
                            'advs' => 'advs',
                            'store' => 'store',
                            'cats' => 'category',
                        ];
                        foreach ($streams as $stream) {
                            if (array_key_exists($stream->namespace, $active_streams) and in_array($stream->slug, $active_streams)) {
                                $entry_types[$stream->getId()] = trans($stream->name);
                            }
                        }

                        $fieldType->setOptions($entry_types);
                    }
                ],
            ],
            'coupon_expiry_at',
            'min_cart_price',
            'discount_type',
            'discount_value',
            'value_discount_type',
            'coupon_code',
            'used_only_once'
        ]);
    }
}
