<?php namespace Visiosoft\CouponModule\Coupon\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

class CouponFormBuilder extends FormBuilder
{
    protected $type = null;

    protected $buttons = [
        'cancel',
    ];

    protected $fields = [
        'coupon_name',
        'coupon_expiry_at',
        'min_cart_price',
        'discount_type',
        'discount_value',
        'value_discount_type',
        'no_of_codes' => [
            'label' => 'visiosoft.module.coupon::field.no_of_codes.name',
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'min' => 0,
                'max' => 9999,
            ],
            'required' => true,
        ],
        'used_only_once'
    ];

    protected $options = [
        'form_view' => 'visiosoft.module.coupon::admin/coupon/form',
        'redirect' => 'admin/coupon',
    ];

    public function onSaving()
    {
        $entry = $this->getFormEntry();
        $type = $this->getType();

        if ($type) {
            $entry->coupon_type_id = $type;
        }
    }

    public function getType()
    {
        return $this->type;
    }

    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }
}
